
 /**
 ******************************************************************************
 *
 * @file        main.c
 * @brief       MG04-06 main file
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2022/08/01
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
/* Includes ------------------------------------------------------------------*/
#include "MG32_ChipInit.h"
#include "MG04_06_Global.h"
#include "BSP_Common_MG04_06.h"
#include "BSP_SARADCKey.h"
#include "BSP_ARGB.h"
#include "BSP_SPILCD.h"
#include "BSP_SPIFlash.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
MG04_06_TypeDef MG04_06_CTR;

/* Private function prototypes -----------------------------------------------*/
void SysTick_Handler(void);
void APX_IRQHandler(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	    Systick interrupt handler 
 * @details     MG04-06 project time base (1ms)
 * @return      
 * @exception   No
 * @note
 *******************************************************************************
 */
void SysTick_Handler(void)
{
    BSP_IncTick(); 
    
    //===================================
    // MG04_06 Timebase handle.
    MG04_06_CTR.TimeBase_Flag = 1;
    
    if( MG04_06_CTR.TimeBaseCount == 9)
    {
        MG04_06_CTR.TimeBaseCount = 0;
    }
    else
    {
        MG04_06_CTR.TimeBaseCount  = MG04_06_CTR.TimeBaseCount + 1;
    }
    //===================================
    switch( MG04_06_CTR.TimeBaseCount )
    {
        /* Key Handle*/
        case 0:
                API_DetectSARADCKey();                                  /*!< Detect SARADC key status in every 10ms*/
                API_DetectTouchKey();                                   /*!< Detect Touch key status in every 10ms*/
                break;                                                  
        case 1:                                                         
                API_Key_Handle();                                       /*!< Handle key function according to key status (SARADC Key & Touch Key)*/
                break;                                                  
        /*ARGB Handle*/                                                 
        case 2:                                                         
                API_ARGBDrama_Handle();                                 /*!< Decide ARGB next status according to ARGB mode*/
                BSP_ARGB_DataUpdate();                                  /*!< Update ARGB status*/
                break;
        default:
                break;
    }
}

/**
 *******************************************************************************
 * @brief	    ASB of APX interrupt handler
 * @details     It is ARGB transmit interrupt function.
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */
void APX_IRQHandler(void)
{
    BSP_ASB_IRQHandle();
}
/**
 *******************************************************************************
 * @brief	    MG04-06 main function
 * @details     
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */
int main(void)
{
    
    /* chip initial (User can enable CSC, GPIO, TM, ADC, EXIC ... wizard)*/
    ChipInit();
    
    /*Control Relationship Initial.*/
    BSP_Init();

    /*main function*/
    while(1)
    {
        if( MG04_06_CTR.TimeBase_Flag == 1)
        {
            MG04_06_CTR.TimeBase_Flag = 0;

            /*Distribute Timer to Handle (unit 10ms) */
            switch( MG04_06_CTR.TimeBaseCount )
            {
                /*LCD Background Handle*/
                case MG04_06_TIMEHANDLE_BACKGROUND:
                                                   API_LCD_BackgroundUpdate();           /*!< Update LCD background*/
                                                   API_LCD_DynamicUpdate();              /*!< Update LCD displays according user dynamic use*/
                                                   break;
                /*Idle Handle*/
                case 9:
                                                   API_IdleHandle();
                                                   break;
                /*Resever Time*/ 
                default:
                                                   break;
            }
        }
    }
}

 
 
 
 
 
 
 
 
 
